class MM_HUD extends ChallengeHUD;

#exec TEXTURE IMPORT NAME=ScoreIcon FILE=Textures\ScoreIcon.bmp GROUP="HUD" MIPS=ON
#exec TEXTURE IMPORT NAME=AmmoIcon FILE=Textures\AmmoIcon.bmp GROUP="HUD" MIPS=ON
#exec TEXTURE IMPORT NAME=MonsterIcon FILE=Textures\MonsterIcon.bmp GROUP="HUD" MIPS=ON
#exec TEXTURE IMPORT NAME=TombstoneIcon FILE=Textures\TombstoneIcon.bmp GROUP="HUD" MIPS=ON FLAGS=2
#exec TEXTURE IMPORT NAME=ScoreElementA FILE=Textures\ScoreElementA.bmp GROUP="HUD" MIPS=OFF
#exec TEXTURE IMPORT NAME=ScoreElementB FILE=Textures\ScoreElementB.bmp GROUP="HUD" MIPS=OFF
#exec TEXTURE IMPORT NAME=ScoreElementC FILE=Textures\ScoreElementC.bmp GROUP="HUD" MIPS=OFF
#exec TEXTURE IMPORT NAME=ScoreElementD FILE=Textures\ScoreElementD.bmp GROUP="HUD" MIPS=OFF
#exec TEXTURE IMPORT NAME=ScoreElementE FILE=Textures\ScoreElementE.bmp GROUP="HUD" MIPS=OFF
#exec TEXTURE IMPORT NAME=TimeElement FILE=Textures\TimeElement.bmp GROUP="HUD" MIPS=OFF

#exec OBJ LOAD FILE=..\Textures\LadrStatic.utx PACKAGE=Botpack.LadrStatic

var string MMversion;

var() int SizeY,Count;
var string CurrentMessage;
var float MOTDFadeOutTime;

var float IdentifyFadeTime;
var PlayerReplicationInfo IdentifyTarget;
var Pawn PawnOwner;	// pawn currently managing this HUD (may be the viewtarget of the owner rather than the owner)
var FontInfo MyFonts;

// Localized Messages
var HUDLocalizedMessage ShortMessageQueue[4];
var HUDLocalizedMessage LocalMessages[10];

var texture FaceTexture;
var float FaceTime;
var color FaceTeam;
 
var() localized string VersionMessage, PlayerCountString;
var localized string MapTitleString, AuthorString;
var localized string MapTitleString2, AuthorString2;

var localized string RankString;
var localized string SpreadString;

var int PlayerCount;
var bool bTiedScore;

var string ReceivedMessage;
var string ReceivedName;
var ZoneInfo ReceivedZone;
var float ReceivedTime;
var texture TutIconTex;
var int TutIconX, TutIconY;
var float TutIconBlink;

var texture CrossHairTextures[20];

var texture GrayWeapons[11];
var texture FP1[3], FP2[3], FP3[3];
var int LastReportedTime;
var bool bStartUpMessage, bForceScores;
var bool bTimeValid;
var bool bLowRes;
var bool bResChanged;
var int OldClipX;

// configuration options
var bool bAlwaysHideFrags, bHideCenterMessages;
var float Scale;
var byte Style;
var color BaseColor, WhiteColor, RedColor, GreenColor, CyanColor, UnitColor, BlueColor,
		 GoldColor, HUDColor, SolidHUDColor, PurpleColor, TurqColor, GrayColor, FaceColor;

// Identify Strings
var localized string IdentifyName, IdentifyHealth, IdentifyCallsign;
var localized string LiveFeed;

// scoring 
var float ScoreTime;
var int rank, lead;

// showing damage
var vector HitPos[4];
var float HitTime[4];
var float HitDamage[4];

var float PickupTime;

var float WeaponNameFade;
var float MessageFadeTime;
var int MessageFadeCount;
var bool bDrawMessageArea;
var bool bDrawFaceArea;
var float FaceAreaOffset, MinFaceAreaOffset;
var class<CriticalEventPlus> TimeMessageClass;

// Server info.
var ServerInfo ServerInfo;
var bool bShowInfo;

var class<ServerInfo> ServerInfoClass;

var float y0, y1, y2, y3, y4, y5, y6, y7, y8, y9, y10;

simulated function DrawStats(Canvas Canvas)
{
local float XL,YL;
local MonsterPRI MPRI;

	MPRI = MonsterPRI(PlayerPawn(Owner).PlayerReplicationInfo);
	Canvas.Font = MyFonts.GetAReallySmallFont( Canvas.ClipX );
	Canvas.Style = ERenderStyle.STY_Translucent;

	Canvas.StrLen("Top 10 players:", XL, YL);
	Canvas.DrawColor.R = int(y0);
	Canvas.DrawColor.G = int(y0);
	Canvas.DrawColor.B = int(y0);
	Canvas.SetPos(Canvas.ClipX * 0.75 - 0.5 * XL, Canvas.ClipY - 145 + y0);
	Canvas.DrawText("Top 10 players:", False);

	Canvas.StrLen(MPRI.Player1, XL, YL);
	Canvas.DrawColor.R = int(y1);
	Canvas.DrawColor.G = int(y1);
	Canvas.DrawColor.B = int(y1);
	Canvas.SetPos(Canvas.ClipX * 0.75 - 0.5 * XL, Canvas.ClipY - 145 + y1);
	Canvas.DrawText(MPRI.Player1, False);

	Canvas.StrLen(MPRI.Player2, XL, YL);
	Canvas.DrawColor.R = int(y2);
	Canvas.DrawColor.G = int(y2);
	Canvas.DrawColor.B = int(y2);
	Canvas.SetPos(Canvas.ClipX * 0.75 - 0.5 * XL, Canvas.ClipY - 145 + y2);
	Canvas.DrawText(MPRI.Player2, False);

	Canvas.StrLen(MPRI.Player3, XL, YL);
	Canvas.DrawColor.R = int(y3);
	Canvas.DrawColor.G = int(y3);
	Canvas.DrawColor.B = int(y3);
	Canvas.SetPos(Canvas.ClipX * 0.75 - 0.5 * XL, Canvas.ClipY - 145 + y3);
	Canvas.DrawText(MPRI.Player3, False);

	Canvas.StrLen(MPRI.Player4, XL, YL);
	Canvas.DrawColor.R = int(y4);
	Canvas.DrawColor.G = int(y4);
	Canvas.DrawColor.B = int(y4);
	Canvas.SetPos(Canvas.ClipX * 0.75 - 0.5 * XL, Canvas.ClipY - 145 + y4);
	Canvas.DrawText(MPRI.Player4, False);

	Canvas.StrLen(MPRI.Player5, XL, YL);
	Canvas.DrawColor.R = int(y5);
	Canvas.DrawColor.G = int(y5);
	Canvas.DrawColor.B = int(y5);
	Canvas.SetPos(Canvas.ClipX * 0.75 - 0.5 * XL, Canvas.ClipY - 145 + y5);
	Canvas.DrawText(MPRI.Player5, False);

	Canvas.StrLen(MPRI.Player6, XL, YL);
	Canvas.DrawColor.R = int(y6);
	Canvas.DrawColor.G = int(y6);
	Canvas.DrawColor.B = int(y6);
	Canvas.SetPos(Canvas.ClipX * 0.75 - 0.5 * XL, Canvas.ClipY - 145 + y6);
	Canvas.DrawText(MPRI.Player6, False);

	Canvas.StrLen(MPRI.Player7, XL, YL);
	Canvas.DrawColor.R = int(y7);
	Canvas.DrawColor.G = int(y7);
	Canvas.DrawColor.B = int(y7);
	Canvas.SetPos(Canvas.ClipX * 0.75 - 0.5 * XL, Canvas.ClipY - 145 + y7);
	Canvas.DrawText(MPRI.Player7, False);

	Canvas.StrLen(MPRI.Player8, XL, YL);
	Canvas.DrawColor.R = int(y8);
	Canvas.DrawColor.G = int(y8);
	Canvas.DrawColor.B = int(y8);
	Canvas.SetPos(Canvas.ClipX * 0.75 - 0.5 * XL, Canvas.ClipY - 145 + y8);
	Canvas.DrawText(MPRI.Player8, False);

	Canvas.StrLen(MPRI.Player9, XL, YL);
	Canvas.DrawColor.R = int(y9);
	Canvas.DrawColor.G = int(y9);
	Canvas.DrawColor.B = int(y9);
	Canvas.SetPos(Canvas.ClipX * 0.75 - 0.5 * XL, Canvas.ClipY - 145 + y9);
	Canvas.DrawText(MPRI.Player9, False);

	Canvas.StrLen(MPRI.Player10, XL, YL);
	Canvas.DrawColor.R = int(y10);
	Canvas.DrawColor.G = int(y10);
	Canvas.DrawColor.B = int(y10);
	Canvas.SetPos(Canvas.ClipX * 0.75 - 0.5 * XL, Canvas.ClipY - 145 + y10);
	Canvas.DrawText(MPRI.Player10, False);
}

simulated function MoveStats()
{
local float speed;

	speed = 0.1;

	y0 -= speed;
	if ( y0 < 0 )
		y0 = 255;
	y1 -= speed;
	if ( y1 < 0 )
		y1 = 255;
	y2 -= speed;
	if ( y2 < 0 )
		y2 = 255;
	y3 -= speed;
	if ( y3 < 0 )
		y3 = 255;
	y4 -= speed;
	if ( y4 < 0 )
		y4 = 255;
	y5 -= speed;
	if ( y5 < 0 )
		y5 = 255;
	y6 -= speed;
	if ( y6 < 0 )
		y6 = 255;
	y7 -= speed;
	if ( y7 < 0 )
		y7 = 255;
	y8 -= speed;
	if ( y8 < 0 )
		y8 = 255;
	y9 -= speed;
	if ( y9 < 0 )
		y9 = 255;
	y10 -= speed;
	if ( y10 < 0 )
		y10 = 255;
}

function Destroyed()
{
	Super.Destroyed();
	if ( MyFonts != None )
		MyFonts.Destroy();
}

function SetDamage(vector HitLoc, float damage)
{
	local int i, best;
	local vector X,Y,Z;
	local float Max, XOffset, YOffset;

	if ( Level.bDropDetail || !PlayerOwner.IsA('TournamentPlayer') )
		return;

	for ( i=0; i<4; i++ )
		if ( Level.TimeSeconds - HitTime[i] > Max )
		{
			best = i;	
			Max = Level.TimeSeconds - HitTime[i];
		}

	HitTime[best] = Level.TimeSeconds;
	HitDamage[best] = FClamp(Damage * 0.06,2,4);
	GetAxes(Owner.Rotation,X,Y,Z);
	XOffset = - 0.5 * FClamp((Y Dot HitLoc)/CollisionRadius , -1, 1);
	YOffset = -0.5 * FClamp((Z Dot HitLoc)/CollisionHeight , -1, 1);

	// hack for positions around head or near legs
	if ( YOffset < -0.35 )
	{
		XOffset *= 0.3;
		YOffset = FMax(HitPos[best].Y, -0.45);
	}
	else if ( YOffset > 0.1 )
	{
		if ( abs(XOffset) < 0.25 )
		{
			if ( XOffset > 0 )
				XOffset = 0.25;
			else
				XOffset = -0.25;
		}				
		YOffset = FMin(YOffset, 0.4);
	}

	HitPos[best].X = 128 * (0.5 + XOffset) - 0.5 * 25 * HitDamage[best];
	HitPos[best].Y = 256 * (0.5 + YOffset) - 0.5 * HitDamage[Best] * 64;
}

simulated function PostBeginPlay()
{
	local int i;

	if ( Level.NetMode != NM_Standalone )
		MOTDFadeOutTime = 350;
	FaceAreaOffset = -64;
	MyFonts = FontInfo(spawn(Class<Actor>(DynamicLoadObject(FontInfoClass, class'Class'))));
	Super.PostBeginPlay();
	SetTimer(1.0, True);

	if ( (PlayerPawn(Owner).GameReplicationInfo != None)
		&& (PlayerPawn(Owner).GameReplicationInfo.RemainingTime > 0) )
		TimeMessageClass = class<CriticalEventPlus>(DynamicLoadObject("Botpack.TimeMessage", class'Class'));

	ServerInfo = Spawn(ServerInfoClass, Owner);
}

exec function SetHUDR(int n)
{
	FavoriteHUDColor.R = Clamp(n,0,16);
}

exec function SetHUDG(int n)
{
	FavoriteHUDColor.G = Clamp(n,0,16);
}

exec function SetHUDB(int n)
{
	FavoriteHUDColor.B = Clamp(n,0,16);
}

exec function ShowServerInfo()
{
	if (bShowInfo)
	{
		bShowInfo = False;
	} else {
		bShowInfo = True;
		PlayerPawn(Owner).bShowScores = False;
	}
}

exec function GrowHUD()
{
	if ( bHideHUD )
		bHideHud = false;
	else if ( bHideAmmo )
		bHideAmmo = false;
	else if ( bHideFrags )
		bHideFrags = false;
	else if ( bHideTeamInfo )
		bHideTeamInfo = false;
	else if ( bHideAllWeapons )
		bHideAllWeapons = false;
	else if ( bHideStatus )
		bHideStatus = false;
	else 
		WeaponScale = 1.0;

	SaveConfig();
}

exec function ShrinkHUD()
{
	if ( !bLowRes && (WeaponScale * HUDScale > 0.8) )
		WeaponScale = 0.8/HUDScale;
	else if ( !bHideStatus )
		bHideStatus = true;
	else if ( !bHideAllWeapons )
		bHideAllWeapons = true;
	else if ( !bHideTeamInfo )
		bHideTeamInfo = true;
	else if ( !bHideFrags )
		bHideFrags = true;
	else if ( !bHideAmmo )
		bHideAmmo = true;
	else
		bHideHud = true;

	SaveConfig();
}
	
simulated function ChangeCrosshair(int d)
{
	Crosshair = Crosshair + d;
	if ( Crosshair >= CrossHairCount )
		Crosshair = 0;
	else
	if ( Crosshair < 0 )
		Crosshair = CrossHairCount-1;
}

simulated function Texture LoadCrosshair(int c)
{
	CrossHairTextures[c] = Texture(DynamicLoadObject(CrossHairs[c], class'Texture'));
	return CrossHairTextures[c];
}

simulated function HUDSetup(canvas canvas)
{
	local int FontSize;

	bResChanged = (Canvas.ClipX != OldClipX);
	OldClipX = Canvas.ClipX;
		
	PlayerOwner = PlayerPawn(Owner);
	if ( PlayerOwner.ViewTarget == None )
		PawnOwner = PlayerOwner;
	else if ( PlayerOwner.ViewTarget.bIsPawn )
		PawnOwner = Pawn(PlayerOwner.ViewTarget);
	else 
		PawnOwner = PlayerOwner;

	// Setup the way we want to draw all HUD elements
	Canvas.Reset();
	Canvas.SpaceX=0;
	Canvas.bNoSmooth = True;

	FontSize = Min(3, HUDScale * Canvas.ClipX/500);
	Scale = (HUDScale * Canvas.ClipX)/1280.0;

	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );

	SolidHUDColor = FavoriteHUDColor * 15.9;
	if ( (Opacity == 16) || !Level.bHighDetailMode )
	{
		Style = ERenderStyle.STY_Normal;
		BaseColor = WhiteColor;
		HUDColor = SolidHUDColor;
	}
	else
	{
		Style = ERenderStyle.STY_Translucent;
		BaseColor = (16 * Opacity + 15) * UnitColor;
		HUDColor = FavoriteHUDColor * (Opacity + 0.9);
	}
	Canvas.DrawColor = BaseColor;
	Canvas.Style = Style;
	bLowRes = ( Canvas.ClipX < 400 );
	if ( bLowRes )
		WeaponScale = 1.0;
}

simulated function DrawDigit(Canvas Canvas, int d, int Step, float UpScale, out byte bMinus )
{
	if ( bMinus == 1 )
	{
		Canvas.CurX -= Step;
		Canvas.DrawTile(Texture'BotPack.HudElements1', UpScale*25, 64*UpScale, 0, 64, 25.0, 64.0);
		bMinus = 0;
	}
	if ( d == 1 )
		Canvas.CurX -= 0.625 * Step;
	else
		Canvas.CurX -= 0.25 * Step;		
	Canvas.DrawTile(Texture'BotPack.HudElements1', UpScale*25, 64*UpScale, d*25, 0, 25.0, 64.0);
	Canvas.CurX += 7*UpScale;
}

// DrawBigNum should already have Canvas set up
// X and Y should be the left most allowed position of the number (will be adjusted right if possible)
simulated function DrawBigNum(Canvas Canvas, int Value, int X, int Y, optional float ScaleFactor)
{
	local int d, Mag, Step;
	local float UpScale;
	local byte bMinus;

	if ( ScaleFactor != 0 )
		UpScale = Scale * ScaleFactor;
	else
		UpScale = Scale;

	Canvas.CurX = X;	
	Canvas.CurY = Y;
	Step = 16 * UpScale;
	if ( Value < 0 )
		bMinus = 1;
	Mag = FMin(9999, Abs(Value));

	if ( Mag >= 1000 )
	{
		Canvas.CurX -= Step;
		d = 0.001 * Mag;
		DrawDigit(Canvas, d, Step, UpScale, bMinus);
		Mag = Mag - 1000 * d;
		d = 0.01 * Mag;
		DrawDigit(Canvas, d, Step, UpScale, bMinus);
		Mag = Mag - 100 * d;
	}
	else if ( Mag >= 100 )
	{
		d = 0.01 * Mag;
		DrawDigit(Canvas, d, Step, UpScale, bMinus);
		Mag = Mag - 100 * d;
	}
	else
		Canvas.CurX += Step;

	if ( Mag >= 10 )
	{
		d = 0.1 * Mag;
		DrawDigit(Canvas, d, Step, UpScale, bMinus);
		Mag = Mag - 10 * d;
	}
	else if ( d > 0 )
		DrawDigit(Canvas, 0, Step, UpScale, bMinus);
	else
		Canvas.CurX += Step;

	DrawDigit(Canvas, Mag, Step, UpScale, bMinus);
}

simulated function DrawStatus(Canvas Canvas)
{
	local float StatScale, ChestAmount, ThighAmount, H1, H2, X, Y, DamageTime, XL, YL,ItemY;
	Local int ArmorAmount,CurAbs,i;
	Local inventory Inv,BestArmor;
	local bool bChestArmor, bShieldbelt, bThighArmor, bJumpBoots, bHasDoll;
	local Bot BotOwner;
	local TournamentPlayer TPOwner;
	local texture Doll, DollBelt;

	ArmorAmount = 0;
	CurAbs = 0;
	i = 0;
	BestArmor=None;
	for( Inv=PawnOwner.Inventory; Inv!=None; Inv=Inv.Inventory )
	{ 
		if (Inv.bIsAnArmor) 
		{
			if ( Inv.IsA('UT_Shieldbelt') )
				bShieldbelt = true;
			else if ( Inv.IsA('Thighpads') )
			{
				ThighAmount += Inv.Charge;
				bThighArmor = true;
			}
			else
			{ 
				bChestArmor = true;
				ChestAmount += Inv.Charge;
			}
			ArmorAmount += Inv.Charge;
		}
		else if ( Inv.IsA('UT_JumpBoots') )
			bJumpBoots = true;
		else
		{
			i++;
			if ( i > 100 )
				break; // can occasionally get temporary loops in netplay
		}
	}

	Canvas.DrawColor = HUDColor;

	X = Canvas.ClipX - 128 * StatScale - 140 * Scale;
	Y = 64 * Scale;

	Canvas.SetPos(X,Y);
	if ( PawnOwner.Health < 50 )
	{
		H1 = 1.5 * TutIconBlink;
		H2 = 1 - H1;
		Canvas.DrawColor = WhiteColor * H2 + (HUDColor - WhiteColor) * H1;
	}
	else
		Canvas.DrawColor = HUDColor;
	Canvas.DrawTile(Texture'BotPack.HudElements1', 128*Scale, 64*Scale, 128, 128, 128.0, 64.0);

	if ( PawnOwner.Health < 50 )
	{
		H1 = 1.5 * TutIconBlink;
		H2 = 1 - H1;
		Canvas.DrawColor = Canvas.DrawColor * H2 + (WhiteColor - Canvas.DrawColor) * H1;
	}
	else
		Canvas.DrawColor = WhiteColor;

	DrawBigNum(Canvas, Max(0, PawnOwner.Health), X + 4 * Scale, Y + 16 * Scale, 1);

	Canvas.DrawColor = HUDColor;

	X = Canvas.ClipX - 128 * StatScale - 140 * Scale;
	Y = 0;

	Canvas.SetPos(X, Y);
	Canvas.DrawTile(Texture'BotPack.HudElements1', 128*Scale, 64*Scale, 0, 192, 128.0, 64.0);
	if ( bHideStatus && bShieldBelt )
		Canvas.DrawColor = GoldColor;
	else
		Canvas.DrawColor = WhiteColor;
	DrawBigNum(Canvas, Min(999,ArmorAmount), X + 4 * Scale, Y + 16 * Scale, 1);


	//Draw Time
	X = Canvas.ClipX - 128 * StatScale - 140 * Scale;
	Y = 128 * Scale;

	Canvas.SetPos(X, Y);
	Canvas.DrawColor = HUDColor;
	Canvas.DrawTile(Texture'TimeElement', 128*Scale, 64*Scale, 0, 192, 128.0, 64.0);

	Canvas.DrawColor = WhiteColor;
	Canvas.Font = MyFonts.GetHugeFont( Canvas.ClipX * Scale);
	Style = ERenderStyle.STY_Normal;

	if ( PlayerOwner.GameReplicationInfo.RemainingTime <= 0 )
		{
		Canvas.StrLen("0:00", XL, YL);
		Canvas.SetPos(X + 48 * Scale - 0.5 * XL,Y + 16 * Scale);
		Canvas.DrawText("0:00", False);
		}
	else
		{
		Canvas.StrLen(PlayerOwner.GameReplicationInfo.RemainingTime/60$":", XL, YL);
		Canvas.SetPos(X + 48 * Scale - 0.5 * XL,Y + 16 * Scale);
		Canvas.DrawText(PlayerOwner.GameReplicationInfo.RemainingTime/60$":", False);
		Canvas.SetPos(X + 48 * Scale + 0.5 * XL,Y + 16 * Scale);
		if ( PlayerOwner.GameReplicationInfo.RemainingTime % 60 < 10 )
			Canvas.DrawText("0"$int(PlayerOwner.GameReplicationInfo.RemainingTime % 60), False);
		else
			Canvas.DrawText(int(PlayerOwner.GameReplicationInfo.RemainingTime % 60), False);
		}
	ItemY = Canvas.ClipY * 0.5 + 42;
	
	if ( MonsterPRI(PlayerOwner.PlayerReplicationInfo).AmmoRegenTime > 0 )
		{
		Style = ERenderStyle.STY_Translucent;
		Canvas.SetPos(Canvas.ClipX - 64, ItemY);
		Canvas.DrawTile(Texture'Item_Ammo', 64, 64, 0, 0, 128.0, 128.0);
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX * Scale);
		Style = ERenderStyle.STY_Normal;
		Canvas.StrLen(MonsterPRI(PlayerOwner.PlayerReplicationInfo).AmmoRegenTime, XL, YL);
		Canvas.SetPos(Canvas.ClipX - 62 - XL,ItemY + 32 - 0.5 * YL);
		Canvas.DrawText(MonsterPRI(PlayerOwner.PlayerReplicationInfo).AmmoRegenTime, False);
		ItemY += 54;
		}
	if ( MonsterPRI(PlayerOwner.PlayerReplicationInfo).ImunityTime > 0 )
		{
		Style = ERenderStyle.STY_Translucent;
		Canvas.SetPos(Canvas.ClipX - 64, ItemY);
		Canvas.DrawTile(Texture'Item_Imunity', 64, 64, 0, 0, 128.0, 128.0);
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX * Scale);
		Style = ERenderStyle.STY_Normal;
		Canvas.StrLen(MonsterPRI(PlayerOwner.PlayerReplicationInfo).ImunityTime, XL, YL);
		Canvas.SetPos(Canvas.ClipX - 62 - XL,ItemY + 32 - 0.5 * YL);
		Canvas.DrawText(MonsterPRI(PlayerOwner.PlayerReplicationInfo).ImunityTime, False);
		ItemY += 54;
		}
	if ( MonsterPRI(PlayerOwner.PlayerReplicationInfo).VampireTime > 0 )
		{
		Style = ERenderStyle.STY_Translucent;
		Canvas.SetPos(Canvas.ClipX - 64, ItemY);
		Canvas.DrawTile(Texture'Item_Vampire', 64, 64, 0, 0, 128.0, 128.0);
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX * Scale);
		Style = ERenderStyle.STY_Normal;
		Canvas.StrLen(MonsterPRI(PlayerOwner.PlayerReplicationInfo).VampireTime, XL, YL);
		Canvas.SetPos(Canvas.ClipX - 62 - XL,ItemY + 32 - 0.5 * YL);
		Canvas.DrawText(MonsterPRI(PlayerOwner.PlayerReplicationInfo).VampireTime, False);
		ItemY += 54;
		}
	if ( MonsterPRI(PlayerOwner.PlayerReplicationInfo).LethalAuraTime > 0 )
		{
		Style = ERenderStyle.STY_Translucent;
		Canvas.SetPos(Canvas.ClipX - 64, ItemY);
		Canvas.DrawTile(Texture'Item_LethalAura', 64, 64, 0, 0, 128.0, 128.0);
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX * Scale);
		Style = ERenderStyle.STY_Normal;
		Canvas.StrLen(MonsterPRI(PlayerOwner.PlayerReplicationInfo).LethalAuraTime, XL, YL);
		Canvas.SetPos(Canvas.ClipX - 62 - XL,ItemY + 32 - 0.5 * YL);
		Canvas.DrawText(MonsterPRI(PlayerOwner.PlayerReplicationInfo).LethalAuraTime, False);
		ItemY += 54;
		}
	if ( MonsterPRI(PlayerOwner.PlayerReplicationInfo).SpeedBoostTime > 0 )
		{
		Style = ERenderStyle.STY_Translucent;
		Canvas.SetPos(Canvas.ClipX - 64, ItemY);
		Canvas.DrawTile(Texture'Item_Speed', 64, 64, 0, 0, 128.0, 128.0);
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX * Scale);
		Style = ERenderStyle.STY_Normal;
		Canvas.StrLen(MonsterPRI(PlayerOwner.PlayerReplicationInfo).SpeedBoostTime, XL, YL);
		Canvas.SetPos(Canvas.ClipX - 62 - XL,ItemY + 32 - 0.5 * YL);
		Canvas.DrawText(MonsterPRI(PlayerOwner.PlayerReplicationInfo).SpeedBoostTime, False);
		ItemY += 54;
		}
}

simulated function DrawAmmo(Canvas Canvas)
{
local int Amount;
local float XL,YL;

	if ( PawnOwner.Weapon == none )
		return;
	if ( PawnOwner.Weapon.AmmoType != none )
		{
		Amount = PawnOwner.Weapon.AmmoType.AmmoAmount;
		}
	else
		{
		Amount = 0;
		}

	Canvas.Font = MyFonts.GetHugeFont( Canvas.ClipX );
	Canvas.StrLen(Amount, XL, YL);

	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = HUDColor;
	Canvas.SetPos(Canvas.ClipX - 64 - XL, Canvas.ClipY - 32);
	Canvas.DrawTile(Texture'ScoreElementC', 32, 32, 0, 0, 32.0, 32.0);
	Canvas.SetPos(Canvas.ClipX - 32 - XL, Canvas.ClipY - 32);
	Canvas.DrawTile(Texture'ScoreElementA', 32 + XL, 32, 0, 0, 32.0, 32.0);

	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX - 32, Canvas.ClipY - 32);
	Canvas.DrawTile(Texture'AmmoIcon', 32, 32, 0, 0, 128.0, 128.0);
	Canvas.SetPos(Canvas.ClipX - 32 - XL, Canvas.ClipY - YL + 4);
	Canvas.DrawText(Amount, False);
}

simulated function DrawMonsterCount(Canvas Canvas)
{
local float XL,YL;
local MonsterPRI MPRI;

	MPRI = MonsterPRI(PlayerPawn(Owner).PlayerReplicationInfo);

	Canvas.Font = MyFonts.GetHugeFont( Canvas.ClipX );
	Canvas.StrLen(MPRI.NumMonsters, XL, YL);

	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = HUDColor;
	Canvas.SetPos(Canvas.ClipX - 34 - XL, Canvas.ClipY * 0.5 - 33);
	Canvas.DrawTile(Texture'ScoreElementE', 2, 32, 0, 0, 2.0, 32.0);
	Canvas.SetPos(Canvas.ClipX - 32 - XL, Canvas.ClipY * 0.5 - 33);
	Canvas.DrawTile(Texture'ScoreElementD', 32 + XL, 32, 0, 0, 32.0, 32.0);

	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX - 32, Canvas.ClipY * 0.5 - 33);
	Canvas.DrawTile(Texture'MonsterIcon', 32, 32, 0, 0, 128.0, 128.0);
	Canvas.SetPos(Canvas.ClipX - 32 - XL, Canvas.ClipY * 0.5 - 0.5 * YL - 14);
	Canvas.DrawText(MPRI.NumMonsters, False);
}

simulated function DrawNumKills(Canvas Canvas)
{
local float XL,YL;
local MonsterPRI MPRI;

	MPRI = MonsterPRI(PlayerPawn(Owner).PlayerReplicationInfo);

	Canvas.Font = MyFonts.GetHugeFont( Canvas.ClipX );
	Canvas.StrLen(MPRI.NumKills, XL, YL);

	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = HUDColor;
	Canvas.SetPos(Canvas.ClipX - 34 - XL, Canvas.ClipY * 0.5);
	Canvas.DrawTile(Texture'ScoreElementE', 2, 32, 0, 0, 2.0, 32.0);
	Canvas.SetPos(Canvas.ClipX - 32 - XL, Canvas.ClipY * 0.5);
	Canvas.DrawTile(Texture'ScoreElementD', 32 + XL, 32, 0, 0, 32.0, 32.0);

	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX - 32, Canvas.ClipY * 0.5);
	Canvas.DrawTile(Texture'TombstoneIcon', 32, 32, 0, 0, 128.0, 128.0);
	Canvas.SetPos(Canvas.ClipX - 32 - XL, Canvas.ClipY * 0.5 );
	Canvas.DrawText(MPRI.NumKills, False);
}

simulated function DrawLevel(Canvas Canvas)
{
local float XL,YL;
local MonsterPRI MPRI;

	MPRI = MonsterPRI(PlayerPawn(Owner).PlayerReplicationInfo);

	Canvas.Font = MyFonts.GetAReallySmallFont( Canvas.ClipX );
	Canvas.StrLen("0000", XL, YL);
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(150, Canvas.ClipY - YL);
	Canvas.DrawText("Level:"@MPRI.Level, False);
}

simulated function DrawFragCount(Canvas Canvas)
{
local float Whiten;
local float XL,YL;
local int Score;

	if ( PawnOwner.PlayerReplicationInfo == None )
		return;

	Score = PawnOwner.PlayerReplicationInfo.Score;
	Canvas.Font = MyFonts.GetHugeFont( Canvas.ClipX );
	
	Canvas.DrawColor = HUDColor; 
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.StrLen(Score, XL, YL);

	Canvas.SetPos(0, Canvas.ClipY - 32);
	Canvas.DrawTile(Texture'ScoreElementA', 32 + XL, 32, 0, 0, 32.0, 32.0);	
	Canvas.SetPos(32 + XL, Canvas.ClipY - 32);
	Canvas.DrawTile(Texture'ScoreElementB', 32, 32, 0, 0, 32.0, 32.0);

	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(0, Canvas.ClipY - 32);
	Canvas.DrawTile(Texture'ScoreIcon', 32, 32, 0, 0, 128.0, 128.0);

	Canvas.SetPos(32, Canvas.ClipY - YL + 4);
	Canvas.DrawText(Score, False);
}


simulated function DrawGameSynopsis(Canvas Canvas)
{
	local float XL, YL, XOffset, YOffset;
	local int MaxPlayers;
	local string Spread;

	if ( (PawnOwner.PlayerReplicationInfo == None) 
		|| PawnOwner.PlayerReplicationInfo.bIsSpectator 
		|| (PlayerCount == 1) )
		return;

	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.DrawColor = WhiteColor;

	// Rank String
	Canvas.StrLen(RankString, XL, YL);

	YOffset = Canvas.ClipY - YL*2 - 32;

	Canvas.SetPos(0, YOffset);
	Canvas.DrawText(RankString, False);
	if (bTiedScore)
		Canvas.DrawColor = RedColor;
	Canvas.SetPos(XL, YOffset);
	Canvas.DrawText(" "$Rank@"/"@PlayerCount, False);
	Canvas.DrawColor = WhiteColor;

	// Spread String
	Canvas.SetPos(0, YOffset + YL);
	if (Lead > 0)
		Spread = SpreadString$" +"$Lead;
	else
		Spread = SpreadString$" "$Lead;

	Canvas.DrawText(Spread, False);
}

simulated function DrawWeapons(Canvas Canvas)
{
local Weapon W;
local inventory Inv;
local float XL,YL;

	if ( PawnOwner.Weapon != None )
		{
		W = PawnOwner.Weapon;
		
		Canvas.DrawColor = HUDColor;
		Canvas.Font = MyFonts.GetHugeFont( Canvas.ClipX );
		Canvas.StrLen(W.ItemName, XL, YL);
		Canvas.SetPos(Canvas.ClipX * 0.5 - 0.5 * XL - 32, Canvas.ClipY - 32);
		Canvas.DrawTile(Texture'ScoreElementC', 32, 32, 0, 0, 32.0, 32.0);
		Canvas.SetPos(Canvas.ClipX * 0.5 - 0.5 * XL, Canvas.ClipY - 32);
		Canvas.DrawTile(Texture'ScoreElementA', XL, 32, 0, 0, 32.0, 32.0);
		Canvas.SetPos(Canvas.ClipX * 0.5 + 0.5 * XL, Canvas.ClipY - 32);
		Canvas.DrawTile(Texture'ScoreElementB', 32, 32, 0, 0, 32.0, 32.0);

		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(Canvas.ClipX * 0.5 - 0.5 * XL, Canvas.ClipY - YL + 2);
		Canvas.DrawText(W.ItemName, False);
		}
}

simulated function DisplayProgressMessage( canvas Canvas )
{
	local int i;
	local float XL, YL, YOffset;
	local GameReplicationInfo GRI;

	PlayerOwner.ProgressTimeOut = FMin(PlayerOwner.ProgressTimeOut, Level.TimeSeconds + 8);
	Canvas.Style = ERenderStyle.STY_Normal;	

	Canvas.bCenter = True;
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.StrLen("TEST", XL, YL);
	if ( UTIntro(Level.Game) != None )
		YOffset = 64 * scale + 2 * YL;
	else if ( (MOTDFadeOutTime <= 0) || (Canvas.ClipY < 300) )
		YOffset = 64 * scale + 6 * YL;
	else
	{
		YOffset = 64 * scale + 6 * YL;
		GRI = PlayerOwner.GameReplicationInfo;
		if ( GRI != None )
		{
			if ( GRI.MOTDLine1 != "" )
				YOffset += YL;
			if ( GRI.MOTDLine2 != "" )
				YOffset += YL;
			if ( GRI.MOTDLine3 != "" )
				YOffset += YL;
			if ( GRI.MOTDLine4 != "" )
				YOffset += YL;
		}
	}
	for (i=0; i<8; i++)
	{
		Canvas.SetPos(0, YOffset);
		Canvas.DrawColor = PlayerPawn(Owner).ProgressColor[i];
		Canvas.DrawText(PlayerPawn(Owner).ProgressMessage[i], False);
		YOffset += YL + 1;
	}
	Canvas.DrawColor = WhiteColor;
	Canvas.bCenter = False;
	HUDSetup(Canvas);	
}

function DrawTalkFace(Canvas Canvas, int i, float YPos)
{
	if ( !bHideHUD && !PawnOwner.PlayerReplicationInfo.bIsSpectator )
	{
		Canvas.DrawColor = WhiteColor;
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.SetPos(FaceAreaOffset + 4*Scale, 4*Scale);
		Canvas.DrawTile(FaceTexture, YPos - 1*Scale, YPos - 1*Scale, 0, 0, FaceTexture.USize, FaceTexture.VSize);
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.DrawColor = FaceColor;
		Canvas.SetPos(FaceAreaOffset, 0);
		Canvas.DrawTile(texture'LadrStatic.Static_a00', YPos + 7*Scale, YPos + 7*Scale, 0, 0, texture'LadrStatic.Static_a00'.USize, texture'LadrStatic.Static_a00'.VSize);
		Canvas.DrawColor = WhiteColor;
	}
}

function bool DrawSpeechArea( Canvas Canvas, float XL, float YL )
{
	local float YPos, Yadj;
	local float WackNumber;
	local int paneltype;

	YPos = FMax(YL*4 + 8, 70*Scale);
	Yadj = YPos + 7*Scale;
	YPos *=2;
	MinFaceAreaOffset = -1 * Yadj;
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = HUDColor * MessageFadeTime;

	Canvas.SetPos(FaceAreaOffset, 0);
	Canvas.DrawTile(texture'LadrStatic.Static_a00', Yadj, Yadj, 0, 0, texture'LadrStatic.Static_a00'.USize, texture'LadrStatic.Static_a00'.VSize);

	WackNumber = 512*Scale - 64 + FaceAreaOffset; // 256*Scale - (512*Scale - (768*Scale - 64 + FaceAreaOffset));
	if ( !PlayerOwner.Player.Console.bTyping )
		paneltype = 0;
	else 
	{
		Canvas.StrLen("(>"@PlayerOwner.Player.Console.TypedStr$"_", XL, YL);
		if (XL < 768*Scale)
			paneltype = 1;
		else 
			paneltype = 2;
	}

	Canvas.SetPos(Yadj + FaceAreaOffset, 0);
	Canvas.DrawTile(FP1[paneltype], 256*Scale - FaceAreaOffset, YPos, 0, 0, FP1[paneltype].USize, FP1[paneltype].VSize);

	Yadj += 256 * Scale;
	Canvas.SetPos(Yadj, 0);
	Canvas.DrawTile(FP2[paneltype], WackNumber, YPos, 0, 0, FP2[paneltype].USize, FP2[paneltype].VSize);

	Canvas.SetPos(Yadj + WackNumber, 0);
	Canvas.DrawTile(FP3[paneltype], 64, YPos, 0, 0, FP3[paneltype].USize, FP3[paneltype].VSize);
}

//========================================
// Master HUD render function.

simulated function PostRender( canvas Canvas )
{
	local float XL, YL, XPos, YPos, FadeValue;
	local string Message;
	local int M, i, j, k, XOverflow;
	local float OldOriginX;

	HUDSetup(canvas);
	if ( (PawnOwner == None) || (PlayerOwner.PlayerReplicationInfo == None) )
		return;

	//Draw F2 info screen
	if ( bShowInfo )
		{
		DrawModInfo(Canvas);
		return;
		}

	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	OldOriginX = Canvas.OrgX;
	// Master message short queue control loop.
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.StrLen("TEST", XL, YL);
	Canvas.SetClip(768*Scale - 10, Canvas.ClipY);
	bDrawFaceArea = false;
	if ( !bHideFaces && !PlayerOwner.bShowScores && !bForceScores && !bHideHUD 
			&& !PawnOwner.PlayerReplicationInfo.bIsSpectator && (Scale >= 0.4) )
	{
		DrawSpeechArea(Canvas, XL, YL);
		bDrawFaceArea = (FaceTexture != None) && (FaceTime > Level.TimeSeconds);
		if ( bDrawFaceArea )
		{
			if ( !bHideHUD && ((PawnOwner.PlayerReplicationInfo == None) || !PawnOwner.PlayerReplicationInfo.bIsSpectator) )
				Canvas.SetOrigin( FMax(YL*4 + 8, 70*Scale) + 7*Scale + 6 + FaceAreaOffset, Canvas.OrgY );
		}
	}

	for (i=0; i<4; i++)
	{
		if ( ShortMessageQueue[i].Message != None )
		{
			j++;

			if ( bResChanged || (ShortMessageQueue[i].XL == 0) )
			{
				if ( ShortMessageQueue[i].Message.Default.bComplexString )
					Canvas.StrLen(ShortMessageQueue[i].Message.Static.AssembleString( 
											self,
											ShortMessageQueue[i].Switch,
											ShortMessageQueue[i].RelatedPRI,
											ShortMessageQueue[i].StringMessage), 
								   ShortMessageQueue[i].XL, ShortMessageQueue[i].YL);
				else
					Canvas.StrLen(ShortMessageQueue[i].StringMessage, ShortMessageQueue[i].XL, ShortMessageQueue[i].YL);
				Canvas.StrLen("TEST", XL, YL);
				ShortMessageQueue[i].numLines = 1;
				if ( ShortMessageQueue[i].YL > YL )
				{
					ShortMessageQueue[i].numLines++;
					for (k=2; k<4-i; k++)
					{
						if (ShortMessageQueue[i].YL > YL*k)
							ShortMessageQueue[i].numLines++;
					}
				}
			}

			// Keep track of the amount of lines a message overflows, to offset the next message with.
			Canvas.SetPos(6, 2 + YL * YPos);
			YPos += ShortMessageQueue[i].numLines;
			if ( YPos > 4 )
				break; 

			if ( ShortMessageQueue[i].Message.Default.bComplexString )
			{
				// Use this for string messages with multiple colors.
				ShortMessageQueue[i].Message.Static.RenderComplexMessage( 
					Canvas,
					ShortMessageQueue[i].XL,  YL,
					ShortMessageQueue[i].StringMessage,
					ShortMessageQueue[i].Switch,
					ShortMessageQueue[i].RelatedPRI,
					None,
					ShortMessageQueue[i].OptionalObject
					);				
			} 
			else
			{
				Canvas.DrawColor = ShortMessageQueue[i].Message.Default.DrawColor;
				Canvas.DrawText(ShortMessageQueue[i].StringMessage, False);
			}
		}
	}

	Canvas.DrawColor = WhiteColor;
	Canvas.SetClip(OldClipX, Canvas.ClipY);
	Canvas.SetOrigin(OldOriginX, Canvas.OrgY);

	if ( PlayerOwner.bShowScores || bForceScores )
	{
		if ( (PlayerOwner.Scoring == None) && (PlayerOwner.ScoringType != None) )
			PlayerOwner.Scoring = Spawn(PlayerOwner.ScoringType, PlayerOwner);
		if ( PlayerOwner.Scoring != None )
		{ 
			PlayerOwner.Scoring.OwnerHUD = self;
			PlayerOwner.Scoring.ShowScores(Canvas);
			if ( PlayerOwner.Player.Console.bTyping )
				DrawTypingPrompt(Canvas, PlayerOwner.Player.Console);
			return;
		}
	}

	YPos = FMax(YL*4 + 8, 70*Scale);
	if ( bDrawFaceArea )
		DrawTalkFace( Canvas,0, YPos );
	if (j > 0) 
	{
		bDrawMessageArea = True;
		MessageFadeCount = 2;
	} 
	else 
		bDrawMessageArea = False;

	if ( !bHideCenterMessages )
	{
		// Master localized message control loop.
		for (i=0; i<10; i++)
		{
			if (LocalMessages[i].Message != None)
			{
				if (LocalMessages[i].Message.Default.bFadeMessage && Level.bHighDetailMode)
				{
					Canvas.Style = ERenderStyle.STY_Translucent;
					FadeValue = (LocalMessages[i].EndOfLife - Level.TimeSeconds);
					if (FadeValue > 0.0)
					{
						if ( bResChanged || (LocalMessages[i].XL == 0) )
						{
							if ( LocalMessages[i].Message.Static.GetFontSize(LocalMessages[i].Switch) == 1 )
								LocalMessages[i].StringFont = MyFonts.GetBigFont( Canvas.ClipX );
							else // ==2
								LocalMessages[i].StringFont = MyFonts.GetHugeFont( Canvas.ClipX );
							Canvas.Font = LocalMessages[i].StringFont;
							Canvas.StrLen(LocalMessages[i].StringMessage, LocalMessages[i].XL, LocalMessages[i].YL);
							LocalMessages[i].YPos = LocalMessages[i].Message.Static.GetOffset(LocalMessages[i].Switch, LocalMessages[i].YL, Canvas.ClipY);
						}
						Canvas.Font = LocalMessages[i].StringFont;
						Canvas.DrawColor = LocalMessages[i].DrawColor * (FadeValue/LocalMessages[i].LifeTime);
						Canvas.SetPos( 0.5 * (Canvas.ClipX - LocalMessages[i].XL), LocalMessages[i].YPos );
						Canvas.DrawText( LocalMessages[i].StringMessage, False );
					}
				} 
				else 
				{
					if ( bResChanged || (LocalMessages[i].XL == 0) )
					{
						if ( LocalMessages[i].Message.Static.GetFontSize(LocalMessages[i].Switch) == 1 )
							LocalMessages[i].StringFont = MyFonts.GetBigFont( Canvas.ClipX );
						else // == 2
							LocalMessages[i].StringFont = MyFonts.GetHugeFont( Canvas.ClipX );
						Canvas.Font = LocalMessages[i].StringFont;
						Canvas.StrLen(LocalMessages[i].StringMessage, LocalMessages[i].XL, LocalMessages[i].YL);
						LocalMessages[i].YPos = LocalMessages[i].Message.Static.GetOffset(LocalMessages[i].Switch, LocalMessages[i].YL, Canvas.ClipY);
					}
					Canvas.Font = LocalMessages[i].StringFont;
					Canvas.Style = ERenderStyle.STY_Normal;
					Canvas.DrawColor = LocalMessages[i].DrawColor;
					Canvas.SetPos( 0.5 * (Canvas.ClipX - LocalMessages[i].XL), LocalMessages[i].YPos );
					Canvas.DrawText( LocalMessages[i].StringMessage, False );
				}
			}
		}
	}
	Canvas.Style = ERenderStyle.STY_Normal;

	if ( !PlayerOwner.bBehindView && (PawnOwner.Weapon != None) && (Level.LevelAction == LEVACT_None) )
	{
		Canvas.DrawColor = WhiteColor;
		PawnOwner.Weapon.PostRender(Canvas);
		if ( !PawnOwner.Weapon.bOwnsCrossHair )
			DrawCrossHair(Canvas, 0,0 );
	}

	if ( (PawnOwner != Owner) && PawnOwner.bIsPlayer )
	{
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		Canvas.bCenter = true;
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.DrawColor = CyanColor * TutIconBlink;
		Canvas.SetPos(4, Canvas.ClipY - 96 * Scale);
		Canvas.DrawText( LiveFeed$PawnOwner.PlayerReplicationInfo.PlayerName, true );
		Canvas.bCenter = false;
		Canvas.DrawColor = WhiteColor;
		Canvas.Style = Style;
	}

	if ( bStartUpMessage && (Level.TimeSeconds < 5) )
	{
		bStartUpMessage = false;
		PlayerOwner.SetProgressTime(7);
	}
	if ( (PlayerOwner.ProgressTimeOut > Level.TimeSeconds) && !bHideCenterMessages )
		DisplayProgressMessage(Canvas);

	// Display MOTD
	if ( MOTDFadeOutTime > 0.0 )
		DrawMOTD(Canvas);
		 
	if( !bHideHUD )
	{
		if ( !PawnOwner.PlayerReplicationInfo.bIsSpectator )
		{
			Canvas.Style = Style;

			// Draw Ammo
			if ( !bHideAmmo )
				DrawAmmo(Canvas);
			
			// Draw Health/Armor status
			DrawStatus(Canvas);

			// Display Weapons
			if ( !bHideAllWeapons )
				DrawWeapons(Canvas);
			else if ( Level.bHighDetailMode
					&& (PawnOwner == PlayerOwner) && (PlayerOwner.Handedness == 2) )
			{
				// if weapon bar hidden and weapon hidden, draw weapon name when it changes
				if ( PawnOwner.PendingWeapon != None )
				{
					WeaponNameFade = 1.0;
					Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
					Canvas.DrawColor = PawnOwner.PendingWeapon.NameColor;
					Canvas.SetPos(Canvas.ClipX - 360 * Scale, Canvas.ClipY - 64 * Scale);
					Canvas.DrawText(PawnOwner.PendingWeapon.ItemName, False);
				}
				else if ( (Level.NetMode == NM_Client)  
						&& PawnOwner.IsA('TournamentPlayer') && (TournamentPlayer(PawnOwner).ClientPending != None) )
				{
					WeaponNameFade = 1.0;
					Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
					Canvas.DrawColor = TournamentPlayer(PawnOwner).ClientPending.NameColor;
					Canvas.SetPos(Canvas.ClipX - 360 * Scale, Canvas.ClipY - 64 * Scale);
					Canvas.DrawText(TournamentPlayer(PawnOwner).ClientPending.ItemName, False);
				}
				else if ( (WeaponNameFade > 0) && (PawnOwner.Weapon != None) )
				{
					Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
					Canvas.DrawColor = PawnOwner.Weapon.NameColor;
					if ( WeaponNameFade < 1 )
						Canvas.DrawColor = Canvas.DrawColor * WeaponNameFade;
					Canvas.SetPos(Canvas.ClipX - 360 * Scale, Canvas.ClipY - 64 * Scale);
					Canvas.DrawText(PawnOwner.Weapon.ItemName, False);
				}
			}
			// Display Frag count
			if ( !bAlwaysHideFrags && !bHideFrags )
				DrawFragCount(Canvas);
			DrawMonsterCount(Canvas);
			DrawNumKills(Canvas);
			DrawLevel(Canvas);
			DrawStats(Canvas);
			DrawVersion(Canvas);
		}
		// Team Game Synopsis
		if ( !bHideTeamInfo )
			DrawGameSynopsis(Canvas);

		// Display Identification Info
		if ( PawnOwner == PlayerOwner )
			DrawIdentifyInfo(Canvas);

		if ( HUDMutator != None )
			HUDMutator.PostRender(Canvas);

		if ( (PlayerOwner.GameReplicationInfo != None) && (PlayerPawn(Owner).GameReplicationInfo.RemainingTime > 0) ) 
		{
			if ( TimeMessageClass == None )
				TimeMessageClass = class<CriticalEventPlus>(DynamicLoadObject("Botpack.TimeMessage", class'Class'));

			if ( (PlayerOwner.GameReplicationInfo.RemainingTime <= 300)
			  && (PlayerOwner.GameReplicationInfo.RemainingTime != LastReportedTime) )
			{
				LastReportedTime = PlayerOwner.GameReplicationInfo.RemainingTime;
				if ( PlayerOwner.GameReplicationInfo.RemainingTime <= 30 )
				{
					bTimeValid = ( bTimeValid || (PlayerOwner.GameReplicationInfo.RemainingTime > 0) );	
					if ( PlayerOwner.GameReplicationInfo.RemainingTime == 30 )
						TellTime(5);
					else if ( bTimeValid && PlayerOwner.GameReplicationInfo.RemainingTime <= 10 )
						TellTime(16 - PlayerOwner.GameReplicationInfo.RemainingTime);
				}
				else if ( PlayerOwner.GameReplicationInfo.RemainingTime % 60 == 0 )
				{
					M = PlayerOwner.GameReplicationInfo.RemainingTime/60;
					TellTime(5 - M);
				}
			}
		}
	}
	if ( PlayerOwner.Player.Console.bTyping )
		DrawTypingPrompt(Canvas, PlayerOwner.Player.Console);

	if ( PlayerOwner.bBadConnectionAlert && (PlayerOwner.Level.TimeSeconds > 5) )
	{
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(Canvas.ClipX - (64*Scale), Canvas.ClipY / 2);
		Canvas.DrawIcon(texture'DisconnectWarn', Scale);
	}
}

function Timer()
{
	local int i, j;

	if (!bDrawMessageArea)
	{
		if (MessageFadeCount > 0)
			MessageFadeCount--;
	}

	// Age the short message queue.
	for (i=0; i<4; i++)
	{
		// Purge expired messages.
		if ( (ShortMessageQueue[i].Message != None) && (Level.TimeSeconds >= ShortMessageQueue[i].EndOfLife) )
			ClearMessage(ShortMessageQueue[i]);
	}

	// Clean empty slots.
	for (i=0; i<3; i++)
	{
		if ( ShortMessageQueue[i].Message == None )
		{
			for (j=i; j<4; j++)
			{
				if ( ShortMessageQueue[j].Message != None )
				{
					CopyMessage(ShortMessageQueue[i],ShortMessageQueue[j]);
					ClearMessage(ShortMessageQueue[j]);
					break;
				}
			}
		}
	}

	// Age all localized messages.
	for (i=0; i<10; i++)
	{
		// Purge expired messages.
		if ( (LocalMessages[i].Message != None) && (Level.TimeSeconds >= LocalMessages[i].EndOfLife) )
			ClearMessage(LocalMessages[i]);
	}

	// Clean empty slots.
	for (i=0; i<9; i++)
	{
		if ( LocalMessages[i].Message == None )
		{
			CopyMessage(LocalMessages[i],LocalMessages[i+1]);
			ClearMessage(LocalMessages[i+1]);
		}
	}

	if ( (PlayerOwner == None) || (PawnOwner == None) || (PlayerOwner.GameReplicationInfo == None)
		|| (PawnOwner.PlayerReplicationInfo == None) )
		return;

	// Update the rank and spread.
	UpdateRankAndSpread();
}

function UpdateRankAndSpread()
{
	local PlayerReplicationInfo PRI;
	local int HighScore;
	local int i, j;

	PlayerCount = 0;
	HighScore = -100;
	bTiedScore = False;
	Rank = 1;
	for (i=0; i<32; i++)
	{
		PRI = PlayerOwner.GameReplicationInfo.PRIArray[i];
		if ( (PRI != None) && (!PRI.bIsSpectator || PRI.bWaitingPlayer) )
		{
			PlayerCount++;
			if (PRI != PawnOwner.PlayerReplicationInfo)
			{
				if (PRI.Score > PawnOwner.PlayerReplicationInfo.Score)
					Rank += 1;
				else if (PRI.Score == PawnOwner.PlayerReplicationInfo.Score)
				{
					bTiedScore = True;
					if (PRI.Deaths < PawnOwner.PlayerReplicationInfo.Deaths)
						Rank += 1;
					else if (PRI.Deaths == PawnOwner.PlayerReplicationInfo.Deaths)
						if (PRI.PlayerID < PawnOwner.PlayerReplicationInfo.PlayerID)
							Rank += 1;
				}
				if (PRI.Score > HighScore)
					HighScore = PRI.Score;
			}
		}
	}
	Lead = int(PawnOwner.PlayerReplicationInfo.Score) - HighScore;
}

simulated function TellTime(int num)
{
	PlayerOwner.ReceiveLocalizedMessage( TimeMessageClass, Num );
}

simulated function Tick(float DeltaTime)
{
	local int i;

	Super.Tick(DeltaTime);

	MoveStats();

	IdentifyFadeTime = FMax(0.0, IdentifyFadeTime - DeltaTime);
	MOTDFadeOutTime = FMax(0.0, MOTDFadeOutTime - DeltaTime * 55);
	
	TutIconBlink += DeltaTime;
	if (TutIconBlink >= 0.5)
		TutIconBlink = 0.0;

	if ( bDrawFaceArea )
	{
		if ( FaceAreaOffset < 0 )
			FaceAreaOffset += DeltaTime * 600;
		if ( FaceAreaOffset > 0 )
			FaceAreaOffset = 0.0;
	} 
	else if ( FaceAreaOffset > MinFaceAreaOffset )
		FaceAreaOffset = FMax(FaceAreaOffset - DeltaTime * 600, MinFaceAreaOffset );

	if ( bDrawMessageArea )
	{
		if ( MessageFadeTime < 1.0 )
		{
			MessageFadeTime += DeltaTime * 8;
			if (MessageFadeTime > 1.0)
				MessageFadeTime = 1.0;
		}
	} 
	else if ( (MessageFadeTime > 0.0) && (MessageFadeCount == 0) )
	{
		MessageFadeTime -= DeltaTime * 2;
		if (MessageFadeTime < 0.0)
			MessageFadeTime = 0.0;
	}
	WeaponNameFade -= DeltaTime;

}

simulated function DrawMOTD(Canvas Canvas)
{
	local GameReplicationInfo GRI;
	local float XL, YL;
	local float InitialY;

	GRI = PlayerPawn(Owner).GameReplicationInfo;
	if ( (GRI == None) || (GRI.GameName == "Game") || (MOTDFadeOutTime <= 0) ) 
		return;

	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.Style = Style;
	Canvas.bCenter = true;
	Canvas.DrawColor = UnitColor * MOTDFadeOutTime * 0.5;
	InitialY = 64*Scale;
	Canvas.SetPos(0.0, InitialY);
	Canvas.StrLen("TEST", XL, YL);
	if ( Level.NetMode != NM_Standalone )
	{
		Canvas.DrawText(GRI.ServerName);
		if ( Canvas.ClipY >= 300 )
		{
			Canvas.SetPos(0.0, InitialY + 6*YL);
			Canvas.DrawText(GRI.MOTDLine1, true);
			Canvas.SetPos(0.0, InitialY + 7*YL);
			Canvas.DrawText(GRI.MOTDLine2, true);
			Canvas.SetPos(0.0, InitialY + 8*YL);
			Canvas.DrawText(GRI.MOTDLine3, true);
			Canvas.SetPos(0.0, InitialY + 9*YL);
			Canvas.DrawText(GRI.MOTDLine4, true);
		}
	}
	Canvas.DrawColor = UnitColor * MOTDFadeOutTime * 0.6;
	Canvas.SetPos(0.0, InitialY + YL);
	Canvas.DrawText(GRI.GameName, true);
	Canvas.SetPos(0.0, InitialY + 2*YL);
	Canvas.DrawText(MapTitleString2@Level.Title, true);
	if ( Canvas.ClipY >= 300 )
	{
		Canvas.SetPos(0.0, InitialY + 3*YL);
		Canvas.DrawText(AuthorString2@Level.Author, true);
		if (Level.IdealPlayerCount != "")
		{
			Canvas.SetPos(0.0, InitialY + 4*YL);
			Canvas.DrawText(PlayerCountString$Level.IdealPlayerCount, true);
		}
	}
	Canvas.bCenter = false;
}

simulated function DrawCrossHair( canvas Canvas, int X, int Y)
{
	local float XScale, PickDiff;
	local float XLength;
	local texture T;

 	if (Crosshair>=CrosshairCount) Return;
	if ( Canvas.ClipX < 512 )
		XScale = 0.5;
	else
		XScale = FMax(1, int(0.1 + Canvas.ClipX/640.0));
	PickDiff = Level.TimeSeconds - PickupTime;
	if ( PickDiff < 0.4 )
	{
		if ( PickDiff < 0.2 )
			XScale *= (1 + 5 * PickDiff);
		else
			XScale *= (3 - 5 * PickDiff);
	}
	XLength = XScale * 64.0;

	Canvas.bNoSmooth = False;
	if ( PlayerOwner.Handedness == -1 )
		Canvas.SetPos(0.503 * (Canvas.ClipX - XLength), 0.504 * (Canvas.ClipY - XLength));
	else if ( PlayerOwner.Handedness == 1 )
		Canvas.SetPos(0.497 * (Canvas.ClipX - XLength), 0.496 * (Canvas.ClipY - XLength));
	else
		Canvas.SetPos(0.5 * (Canvas.ClipX - XLength), 0.5 * (Canvas.ClipY - XLength));
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = 15 * CrosshairColor;

	T = CrossHairTextures[Crosshair];
	if( T == None )
		T = LoadCrosshair(Crosshair);

	Canvas.DrawTile(T, XLength, XLength, 0, 0, 64, 64);
	Canvas.bNoSmooth = True;
	Canvas.Style = Style;
}

simulated function DrawTypingPrompt( canvas Canvas, console Console )
{
	local string TypingPrompt;
	local float XL, YL, YPos, XOffset;
	local float MyOldClipX, OldClipY, OldOrgX, OldOrgY;

	MyOldClipX = Canvas.ClipX;
	OldClipY = Canvas.ClipY;
	OldOrgX = Canvas.OrgX;
	OldOrgY = Canvas.OrgY;

	Canvas.DrawColor = GreenColor;
	TypingPrompt = "(>"@Console.TypedStr$"_";
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.StrLen( "TEST", XL, YL );
	YPos = YL*4 + 8;
	if (PawnOwner.PlayerReplicationInfo.bIsSpectator || bHideHUD || bHideFaces)
		XOffset = 0;
	else
		XOffset = FMax(0,FaceAreaOffset + 15*Scale + YPos);
	Canvas.SetOrigin(XOffset, FMax(0,YPos + 7*Scale));
	Canvas.SetClip( 760*Scale, Canvas.ClipY );
	Canvas.SetPos( 0, 0 );
	Canvas.DrawText( TypingPrompt, false );
	Canvas.SetOrigin( OldOrgX, OldOrgY );
	Canvas.SetClip( MyOldClipX, OldClipY );
}

// Entry point for string messages.
simulated function Message( PlayerReplicationInfo PRI, coerce string Msg, name MsgType )
{
	local int i;
	local Class<LocalMessage> MessageClass;

	switch (MsgType)
	{
		case 'Say':
		case 'TeamSay':
			MessageClass = class'SayMessagePlus';
			break;
		case 'CriticalEvent':
			MessageClass = class'CriticalStringPlus';
			LocalizedMessage( MessageClass, 0, None, None, None, Msg );
			return;
		case 'DeathMessage':
			MessageClass = class'RedSayMessagePlus';
			break;
		case 'Pickup':
			PickupTime = Level.TimeSeconds;
		default:
			MessageClass = class'StringMessagePlus';
			break;
	}

	if ( ClassIsChildOf(MessageClass, class'SayMessagePlus') || 
				     ClassIsChildOf(MessageClass, class'TeamSayMessagePlus') )
	{
		FaceTexture = PRI.TalkTexture;
		if ( FaceTexture != None )
			FaceTime = Level.TimeSeconds + 3;
		if ( Msg == "" )
			return;
	} 
	for (i=0; i<4; i++)
	{
		if ( ShortMessageQueue[i].Message == None )
		{
			// Add the message here.
			ShortMessageQueue[i].Message = MessageClass;
			ShortMessageQueue[i].Switch = 0;
			ShortMessageQueue[i].RelatedPRI = PRI;
			ShortMessageQueue[i].OptionalObject = None;
			ShortMessageQueue[i].EndOfLife = MessageClass.Default.Lifetime + Level.TimeSeconds;
			if ( MessageClass.Default.bComplexString )
				ShortMessageQueue[i].StringMessage = Msg;
			else
				ShortMessageQueue[i].StringMessage = MessageClass.Static.AssembleString(self,0,PRI,Msg);
			return;
		}
	}

	// No empty slots.  Force a message out.
	for (i=0; i<3; i++)
		CopyMessage(ShortMessageQueue[i], ShortMessageQueue[i+1]);

	ShortMessageQueue[3].Message = MessageClass;
	ShortMessageQueue[3].Switch = 0;
	ShortMessageQueue[3].RelatedPRI = PRI;
	ShortMessageQueue[3].OptionalObject = None;
	ShortMessageQueue[3].EndOfLife = MessageClass.Default.Lifetime + Level.TimeSeconds;
	if ( MessageClass.Default.bComplexString )
		ShortMessageQueue[3].StringMessage = Msg;
	else
		ShortMessageQueue[3].StringMessage = MessageClass.Static.AssembleString(self,0,PRI,Msg);
}

simulated function bool DisplayMessages( canvas Canvas )
{
	return true;
}

simulated function float DrawNextMessagePart(Canvas Canvas, string MString, float XOffset, int YPos)
{
	local float XL, YL;

	Canvas.SetPos(4 + XOffset, YPos);
	Canvas.StrLen( MString, XL, YL );
	Canvas.DrawText( MString, false );
	return (XOffset + XL);
}

//================================================================================
// Identify Info

simulated function bool TraceIdentify(canvas Canvas)
{
	local actor Other;
	local vector HitLocation, HitNormal, StartTrace, EndTrace;

	StartTrace = PawnOwner.Location;
	StartTrace.Z += PawnOwner.BaseEyeHeight;
	EndTrace = StartTrace + vector(PawnOwner.ViewRotation) * 1000.0;
	Other = Trace(HitLocation, HitNormal, EndTrace, StartTrace, true);

	if ( Pawn(Other) != None )
	{
		if ( Pawn(Other).bIsPlayer && !Other.bHidden )
		{
			IdentifyTarget = Pawn(Other).PlayerReplicationInfo;
			IdentifyFadeTime = 3.0;
		}
	}
	else if ( (Other != None) && SpecialIdentify(Canvas, Other) )
		return false;

	if ( (IdentifyFadeTime == 0.0) || (IdentifyTarget == None) || IdentifyTarget.bFeigningDeath )
		return false;

	return true;
}

simulated function bool SpecialIdentify(Canvas Canvas, Actor Other )
{
	return false;
}

simulated function SetIDColor( Canvas Canvas, int type )
{
	Canvas.DrawColor = GreenColor;
	if ( type == 0 )
		Canvas.DrawColor.G = 160 * (IdentifyFadeTime / 3.0);
	else
		Canvas.DrawColor.G = 255 * (IdentifyFadeTime / 3.0);
}

simulated function DrawTwoColorID( canvas Canvas, string TitleString, string ValueString, int YStart )
{
	local float XL, YL, XOffset, X1;

	Canvas.Style = Style;
	Canvas.StrLen(TitleString$": ", XL, YL);
	X1 = XL;
	Canvas.StrLen(ValueString, XL, YL);
	XOffset = Canvas.ClipX/2 - (X1+XL)/2;
	Canvas.SetPos(XOffset, YStart);
	SetIDColor(Canvas,0);
	XOffset += X1;
	Canvas.DrawText(TitleString);
	Canvas.SetPos(XOffset, YStart);
	SetIDColor(Canvas,1);
	Canvas.DrawText(ValueString);
	Canvas.DrawColor = WhiteColor;
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
}
	
simulated function bool DrawIdentifyInfo(canvas Canvas)
{
	if ( !TraceIdentify(Canvas))
		return false;

	if( IdentifyTarget.PlayerName != "" )
	{
		Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);
		DrawTwoColorID(Canvas,IdentifyName, IdentifyTarget.PlayerName, Canvas.ClipY - 256 * Scale);
	}
	return true;
}

//=====================================================================
// Deal with a localized message.

simulated function LocalizedMessage( class<LocalMessage> Message, optional int Switch, optional PlayerReplicationInfo RelatedPRI_1, optional PlayerReplicationInfo RelatedPRI_2, optional Object OptionalObject, optional String CriticalString )
{
	local int i;

	if ( ClassIsChildOf( Message, class'PickupMessagePlus' ) )
		PickupTime = Level.TimeSeconds;

	if ( !Message.Default.bIsSpecial )
	{
		if ( ClassIsChildOf(Message, class'SayMessagePlus') || 
						 ClassIsChildOf(Message, class'TeamSayMessagePlus') )
		{
			FaceTexture = RelatedPRI_1.TalkTexture;
			if ( FaceTexture != None )
				FaceTime = Level.TimeSeconds + 3;
		} 
		// Find an empty slot.
		for (i=0; i<4; i++)
		{
			if ( ShortMessageQueue[i].Message == None )
			{
				ShortMessageQueue[i].Message = Message;
				ShortMessageQueue[i].Switch = Switch;
				ShortMessageQueue[i].RelatedPRI = RelatedPRI_1;
				ShortMessageQueue[i].OptionalObject = OptionalObject;
				ShortMessageQueue[i].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
				if ( Message.Default.bComplexString )
					ShortMessageQueue[i].StringMessage = CriticalString;
				else
					ShortMessageQueue[i].StringMessage = Message.Static.GetString(Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);
				return;
			}

		}
		// No empty slots.  Force a message out.
		for (i=0; i<3; i++)
			CopyMessage(ShortMessageQueue[i], ShortMessageQueue[i+1]);

		ShortMessageQueue[3].Message = Message;
		ShortMessageQueue[3].Switch = Switch;
		ShortMessageQueue[3].RelatedPRI = RelatedPRI_1;
		ShortMessageQueue[3].OptionalObject = OptionalObject;
		ShortMessageQueue[3].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
		if ( Message.Default.bComplexString )
			ShortMessageQueue[3].StringMessage = CriticalString;
		else
			ShortMessageQueue[3].StringMessage = Message.Static.GetString(Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);
		return;
	} 
	else 
	{
		if ( CriticalString == "" )
			CriticalString = Message.Static.GetString(Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);
		if ( Message.Default.bIsUnique )
		{
			for (i=0; i<10; i++)
			{
				if (LocalMessages[i].Message != None)
				{
					if ((LocalMessages[i].Message == Message) 
						|| (LocalMessages[i].Message.Static.GetOffset(LocalMessages[i].Switch, 24, 640) 
								== Message.Static.GetOffset(Switch, 24, 640)) ) 
					{
						LocalMessages[i].Message = Message;
						LocalMessages[i].Switch = Switch;
						LocalMessages[i].RelatedPRI = RelatedPRI_1;
						LocalMessages[i].OptionalObject = OptionalObject;
						LocalMessages[i].LifeTime = Message.Default.Lifetime;
						LocalMessages[i].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
						LocalMessages[i].StringMessage = CriticalString;
						LocalMessages[i].DrawColor = Message.Static.GetColor(Switch, RelatedPRI_1, RelatedPRI_2);				
						LocalMessages[i].XL = 0;
						return;
					}
				}
			}
		}
		for (i=0; i<10; i++)
		{
			if (LocalMessages[i].Message == None)
			{
				LocalMessages[i].Message = Message;
				LocalMessages[i].Switch = Switch;
				LocalMessages[i].RelatedPRI = RelatedPRI_1;
				LocalMessages[i].OptionalObject = OptionalObject;
				LocalMessages[i].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
				LocalMessages[i].StringMessage = CriticalString;
				LocalMessages[i].DrawColor = Message.Static.GetColor(Switch, RelatedPRI_1, RelatedPRI_2);				
				LocalMessages[i].LifeTime = Message.Default.Lifetime;
				LocalMessages[i].XL = 0;
				return;
			}
		}

		// No empty slots.  Force a message out.
		for (i=0; i<9; i++)
			CopyMessage(LocalMessages[i],LocalMessages[i+1]);

		LocalMessages[9].Message = Message;
		LocalMessages[9].Switch = Switch;
		LocalMessages[9].RelatedPRI = RelatedPRI_1;
		LocalMessages[9].OptionalObject = OptionalObject;
		LocalMessages[9].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
		LocalMessages[9].StringMessage = CriticalString;
		LocalMessages[9].DrawColor = Message.Static.GetColor(Switch, RelatedPRI_1, RelatedPRI_2);				
		LocalMessages[9].LifeTime = Message.Default.Lifetime;
		LocalMessages[9].XL = 0;
		return;
	}
}

simulated function DrawVersion(Canvas Canvas)
{
local float XL,YL;

	Canvas.Font = MyFonts.GetAReallySmallFont( Canvas.ClipX );
	Canvas.StrLen(MMversion, XL, YL);
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX - XL, 0);
	Canvas.DrawText(MMversion, False);
}

simulated function DrawModInfo(Canvas Canvas)
{
local float XL,YL,Ypos;

	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.StrLen("TEST", XL, YL);
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor = WhiteColor;
	Canvas.bCenter = True;
	
	Ypos = 2 * YL;
	
	Canvas.SetPos(0, 0);
	Canvas.DrawText("MonsterMatch Mod Info", False);
	
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.StrLen("TEST", XL, YL);
	Canvas.SetPos(0, Ypos);
	Canvas.DrawText("Coding and concept by TheDane - www.thedane.net", False);
	Ypos += 2 * YL;
	
	Canvas.bCenter = False;
	
	//Draw Ammo Regain Pickup info:
	Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 32, Ypos);
	Canvas.DrawTile(Texture'Item_Ammo', 64, 64, 0, 0, 128.0, 128.0);
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.SetPos(Canvas.ClipX * 0.5 + 32, Ypos + 32 - 0.5 * YL);
	Canvas.DrawText("Ammo regeneration.", False);
	
	Ypos += 65;
	
	//Draw Health Pickup info:
	Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 32, Ypos);
	Canvas.DrawTile(Texture'Item_Health', 64, 64, 0, 0, 128.0, 128.0);
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.SetPos(Canvas.ClipX * 0.5 + 32, Ypos + 32 - 0.5 * YL);
	Canvas.DrawText("+50 Health.", False);
	
	Ypos += 65;
	
	//Draw Armor Pickup info:
	Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 32, Ypos);
	Canvas.DrawTile(Texture'Item_Armor', 64, 64, 0, 0, 128.0, 128.0);
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.SetPos(Canvas.ClipX * 0.5 + 32, Ypos + 32 - 0.5 * YL);
	Canvas.DrawText("+100 Armor.", False);
	
	Ypos += 65;
	
	//Draw Imunity Pickup info:
	Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 32, Ypos);
	Canvas.DrawTile(Texture'Item_Imunity', 64, 64, 0, 0, 128.0, 128.0);
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.SetPos(Canvas.ClipX * 0.5 + 32, Ypos + 32 - 0.5 * YL);
	Canvas.DrawText("Imunity towards damage.", False);
	
	Ypos += 65;
	
	//Draw Vampire Pickup info:
	Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 32, Ypos);
	Canvas.DrawTile(Texture'Item_Vampire', 64, 64, 0, 0, 128.0, 128.0);
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.SetPos(Canvas.ClipX * 0.5 + 32, Ypos + 32 - 0.5 * YL);
	Canvas.DrawText("Gain health from frags.", False);
	
	Ypos += 65;
	
	//Draw Lethal Aura Pickup info:
	Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 32, Ypos);
	Canvas.DrawTile(Texture'Item_LethalAura', 64, 64, 0, 0, 128.0, 128.0);
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.SetPos(Canvas.ClipX * 0.5 + 32, Ypos + 32 - 0.5 * YL);
	Canvas.DrawText("Damage nearby enemies.", False);
	
	Ypos += 65;
	
	//Draw Speed Boost Pickup info:
	Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 32, Ypos);
	Canvas.DrawTile(Texture'Item_Speed', 64, 64, 0, 0, 128.0, 128.0);
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.SetPos(Canvas.ClipX * 0.5 + 32, Ypos + 32 - 0.5 * YL);
	Canvas.DrawText("Move 2x faster.", False);
	
	Ypos += 65;
	
	//Draw Tombstone Pickup info:
	Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 36, Ypos);
	Canvas.DrawTile(Texture'TombstoneIcon', 64, 64, 0, 0, 128.0, 128.0);
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.SetPos(Canvas.ClipX * 0.5 + 32, Ypos + 32 - 0.5 * YL);
	Canvas.DrawText("Bonus health.", False);
	
	Canvas.bCenter = True;
	Canvas.SetPos(0, Canvas.ClipY - YL);
	Canvas.DrawText("Press F2 to close this screen.", False);
	Canvas.bCenter = False;
}

defaultproperties
{
     VersionMessage="Version"
     PlayerCountString="Ideal Player Load:"
     MapTitleString="in"
     AuthorString="by"
     MapTitleString2="Map:"
     AuthorString2="Author:"
     RankString="Rank:"
     SpreadString="Spread:"
     CrosshairCount=9
     CrossHairs(0)="Botpack.CHair1"
     CrossHairs(1)="Botpack.CHair2"
     CrossHairs(2)="Botpack.CHair3"
     CrossHairs(3)="Botpack.CHair4"
     CrossHairs(4)="Botpack.CHair5"
     CrossHairs(5)="Botpack.CHair6"
     CrossHairs(6)="Botpack.CHair7"
     CrossHairs(7)="Botpack.CHair8"
     CrossHairs(8)="Botpack.CHair9"
     FP1(0)=Texture'Botpack.FacePanel.FacePanel1'
     FP1(1)=Texture'Botpack.FacePanel.FacePanel1b'
     FP1(2)=Texture'Botpack.FacePanel.FacePanel1a'
     FP2(0)=Texture'Botpack.FacePanel.FacePanel2'
     FP2(1)=Texture'Botpack.FacePanel.FacePanel2b'
     FP2(2)=Texture'Botpack.FacePanel.FacePanel2a'
     FP3(0)=Texture'Botpack.FacePanel.FacePanel3'
     FP3(1)=Texture'Botpack.FacePanel.FacePanel3b'
     FP3(2)=Texture'Botpack.FacePanel.FacePanel3a'
     bStartUpMessage=True
     bUseTeamColor=True
     Opacity=15
     HUDScale=1.000000
     StatusScale=1.000000
     WeaponScale=0.800000
     FavoriteHUDColor=(B=16)
     CrosshairColor=(G=16)
     Style=3
     WhiteColor=(R=255,G=255,B=255)
     RedColor=(R=255)
     GreenColor=(G=255)
     CyanColor=(G=255,B=255)
     UnitColor=(R=1,G=1,B=1)
     BlueColor=(B=255)
     GoldColor=(R=255,G=255)
     PurpleColor=(R=255,B=255)
     TurqColor=(G=128,B=255)
     GrayColor=(R=200,G=200,B=200)
     FaceColor=(R=50,G=50,B=50)
     IdentifyName="Name:"
     IdentifyHealth="Health:"
     IdentifyCallsign="Callsign:"
     LiveFeed="Live Feed from "
     ScoreTime=-10000000.000000
     ServerInfoClass=Class'Botpack.ServerInfo'
     FontInfoClass="Botpack.FontInfo"
     HUDConfigWindowType="UTMenu.UTChallengeHUDConfig"
     y0=130
     y1=150
     y2=160
     y3=170
     y4=180
     y5=190
     y6=200
     y7=210
     y8=220
     y9=230
     y10=240
     MMversion="v1.06"
}
